#ifndef PARSER_ATP_CRYS_SST_ASYM_H
#define PARSER_ATP_CRYS_SST_ASYM_H


#include "msg_defs.h"
#include "SST_SEP_TST.h"
#include "sst_errors.h"
#include "sst_sep_errors.h"

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_CRYS_SST_RSA      
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application 
* of connection between CRYS and the SSTfunctionality while using SST RSA generated keys
* in the CRYS_SST module
* It calls the SEP function with parameters parsed from input message.
*
*
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_PARSER_CRYS_SST_RSA(DxUint32_t* msg);

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_CRYS_SST_RSA_OAEP_ENCDEC     
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return                                     
*
* Description:                                                                 
*    Test the connection between CRYS and the SSTfunctionality while using SST RSA generated keys
*    in the CRYS_SST module.
*    It calls the SEP function 
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/ 

DxUint32_t DX_SEP_PARSER_CRYS_SST_RSA_OAEP_ENCDEC(DxUint32_t* msg);
/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_CRYS_SST_RSA_PRIM
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
*    Test the connection between CRYS and the SSTfunctionality while using SST RSA generated keys
*    in the CRYS_SST module.
*    It calls the SEP function 
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/ 

DxUint32_t DX_SEP_PARSER_CRYS_SST_RSA_PRIM(DxUint32_t* msg);
#endif
